package com.rocoinfo.rocomall.repository.account;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 通过@MapperScannerConfigurer扫描目录中的所有接口, 动态在Spring Context中生成实现. 方法名称必须与Mapper.xml中保持一致.
 * <dl>
 * <dd>描述: 会员dao</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月4日 上午9:32:29</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@MyBatisRepository
public interface UserDao extends CrudDao<User> {

    User getByUsername(@Param("username") String username);

    User getByMobile(String mobile);

    List<User> findUserByUserNames(List usernames);
}
