package com.rocoinfo.rocomall.repository.activity;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.activity.Activity;
import com.rocoinfo.rocomall.entity.activity.ActivityRecord;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

@MyBatisRepository
public interface ActivityRecordDao extends CrudDao<ActivityRecord> {

	/**
	 * 专题页"查看中奖记录" 按钮的 数字统计: 统计的数字是24小时内= 未挂卡的 + 中奖未填写收货地址的
	 */
	int countUnEraseOrNotFillAddrOfHitByUserAndActivityId(Map<String, Object> params);

	/**
	 * 累计 已经参与活动的 积分
	 */
	int accumulateTotalDeductedCentByActivityId(@Param("activityId") Long activityId);

	/**
	 * 累计 已经参与活动的 积分
	 */
	int accumulateTotalDeductedCentByActivityType(@Param("activityType") Activity.Type activityType);

	void initActivityTotalCent(@Param("activityId") Long activityId);

	void resetActivityTotalCent(@Param("activityId") Long activityId);

	void increaseDeductedTotalCent(@Param("activityId") Long activityId, @Param("incremental") Integer incremental);

	List<ActivityRecord> search(@Param("params") Map<String, Object> params, @Param("pageable") Pageable pageable);

	List<ActivityRecord> searchByUserId(@Param("userId") Long userId, @Param("activityId") Long activityId);

	// 查询中奖记录
	List<ActivityRecord> findHitRecords(Map<String, Object> params);

}
