package com.rocoinfo.rocomall.repository.dict.express;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.FeeItemCity;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 运费模板子项Dao
 * 
 * @author YUZHE 2015年11月25日 下午4:09:33
 */
@MyBatisRepository
public interface ExpressFeeItemDao extends CrudDao<ExpressFeeItem> {

	void saveItemCitys(List<FeeItemCity> itemCityList);

	List<ExpressFeeItem> findItemsByTemplateId(Long templateId);

	public ExpressFeeItem getFeeItemByCityIdAndExpressId(@Param("cityId") Long cityId, @Param("expressId") Long expressId);

	void deleteItemsByTemplateId(Long templateId);

	void deleteItemCitysByItemIds(List<Long> itemIdList);
}
