package com.rocoinfo.rocomall.repository.order;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 订单项处理Dao Created by robin on 14-6-17.
 * 
 * @author yangxc
 * @author huyt
 */
@MyBatisRepository
public interface OrderItemDao extends CrudDao<OrderItem> {

	OrderItem getSaleItemWithExpressById(Long id);

	List<OrderItem> findByOrderId(Long orderId);

	List<OrderItem> findWithSkuByOrderIdsIn(List<Long> orderIdList);

	List<OrderItem> adminSearch(Map<String, Object> params);

	Long adminSearchTotal(Map<String, Object> params);

	/**
	 * 导入Excel时使用的查询方法
	 */
	List<OrderItem> adminExportSearch(Map<String, Object> params);

	/**
	 * 批量更新已支付订单的状态为已处理
	 */
	void dealWithOrderItems(Long... orderItemIds);

	/**
	 * 批量更新状态
	 * 
	 * @param outStatus
	 * @param inStatus
	 */
	void batchUpdateStatus(@Param("outStatus") OrderItem.Status outStatus, @Param("inStatus") OrderItem.AdmStatus inStatus, @Param("ids") List<Long> ids);

	@Deprecated
	Long getIdByOrderCode(String orderCode);

	Long getIdByActIdAndOrderType(Map<String, Object> params);

	/**
	 * 根据OrderCode查询已处理的订单
	 * 
	 * @param orderCodes
	 * @return
	 */
	List<OrderItem> findDealedOrderItemsByCodesIn(List<String> orderCodes);

	List<Map<String, Object>> statisOrderNumGroupByStatus(Long userId);

	List<OrderItem> findOrderItemListByUser(@Param("userId") Long userId, @Param(value = "activityId") Long activityId);

	/**
	 * 根据总订单查询
	 */
	@Deprecated
	public List<OrderItem> searchByOrderCode(Map<String, Object> params);

	/**
	 * 根据总订单查询总数量
	 */
	@Deprecated
	Long searchByOrderCodeTotal(Map<String, Object> params);
}
