package com.rocoinfo.rocomall.repository.order;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:出库单Dao</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月16日 上午10:41:44</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
@MyBatisRepository
public interface OrderOutStoreDao extends CrudDao<OrderOutStore> {
	public List<OrderOutStore> getMergeOrderOutStore(final long dictWarehouseId, final long dictExpressId, final String skuCode);

	/**
	 * 搜索商品的 出库记录 总条数
	 */
	public Long searchTotalOutstoreRecordsByProdId(Map<String, Object> params);

	/**
	 * 搜索商品的 出库记录 当前页的数据
	 */
	public List<OrderOutStore> searchOutstoreRecordsByProdId(Map<String, Object> params);
	
	
	public void upDateOrderItemStatus(@Param("outStatus") OrderItem.Status outStatus,
			@Param("inStatus") OrderItem.AdmStatus inStatus,@Param("id") Long id);
}
