package com.rocoinfo.rocomall.service;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.UserBind;

import java.util.List;

/**
 * <dl>
 * <dd>描述:账户绑定服务</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月5日 上午11:36:33</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public interface IUserBindService extends IBaseService<UserBind> {

	/**
	 * 绑定用户
	 * 
	 * @param userBind 绑定参数
	 * @return 返回绑定结果
	 */
	public StatusDto<String> bindUser(final UserBind userBind);

	/**
	 * @param 其他平台编号
	 * @param 其他平台会员Id
	 * @return 返回是否与积分平台绑定
	 */
	public boolean isBoundUserId(String platformCode, String ouid);

	/**
	 * 返回用户已绑定开通的平台列表
	 */
	public List<UserBind> findBoundOpenedPlatformByUserId(Long userId);

	/**
	 * 返回绑定的积分平台userId,如果尚未绑定，则返回null
	 */
	public Long getBindUserIdByPlatformCodeAndOuid(String platformCode, String ouid);

	/**
	 * 返回绑定的userId,如果尚未绑定，则返回null
	 */
	public Long getBindUserIdByPlatformIdAndOuid(Long platformId, String ouid);

	/**
	 * 返回已经绑定到其他平台的ouid,如果尚未绑定，则返回null
	 */
	public String getBindOuidByPlatformCodeAndUserId(String platformCode, Long userId);

	/**
	 * 返回已绑定的平台数
	 */
	public int countBoundedPlatformsByUserId(Long userId);
}
