package com.rocoinfo.rocomall.service.dict.express;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.enumconst.Status;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/19 上午9:30</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
public interface IDictExpressService extends IBaseService<DictExpress> {

	public Collection<DictExpress> findAllOpenedExpress();

	public Map<Long, DictExpress> findAllExpressMap();

	public boolean isExistCode(final String expressCode);

	public boolean isExistName(final String expressName);

	/**
	 * 根据编号查询快递信息
	 */
	public Map<String, DictExpress> findExpressMapByCodesIn(List<String> expressCodes);

	public List<DictExpress> findAllWithStatus(Status status);

	/**
	 * 根据快递公司ID 查询快递公司绑定的所有城市
	 * 
	 * @param id
	 * @return 2015年11月23日 下午5:48:26
	 */
	public List<DictProviceCity> findAllCityById(Long id);

	/**
	 * 根据快递公司ID 查询快递公司绑定的所有城市Id
	 * 
	 * @param id 快递Id
	 */
	public List<Long> findBoundedCityIdsById(Long id);

	/**
	 * 通过城市Id，获得绑定的快递公司,如果城市尚未绑定快递，则返回null
	 */
	public DictExpress findBoundExpressByCityId(Long cityId);

	/**
	 * 通过城市id查找 绑定的快递信息
	 * 
	 * @param cityIdList 城市Ids
	 * @return 绑定的城市信息与快递信息
	 */
	public List<DictProviceCity> findCityExpressByBoundedCityIds(List<Long> cityIdList);

	/**
	 * 更新快递公司绑定的城市
	 * 
	 * @param express 2015年11月23日 下午6:34:20
	 */
	public void updateCitys(DictExpress express);
}
