package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.account.AdminLog;
import com.rocoinfo.rocomall.repository.account.AdminLogDao;
import com.rocoinfo.rocomall.service.IAdminLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author liuwei
 */
@Service
public class AdminLogService extends CrudService<AdminLogDao, AdminLog> implements IAdminLogService {
	@Autowired
	private UserService accountService;

	public Page<AdminLog> search(Map<String, Object> params, Pageable pageable) {
		long total = entityDao.total(params);
		List<AdminLog> content;
		if (total > pageable.getOffset()) {
			content = entityDao.search(params, pageable);
		} else {
			content = Collections.emptyList();
		}
		return new PageImpl<AdminLog>(content, pageable, total);
	}

	public void buildDetail(AdminLog adminLog) {
		if (adminLog.getUserId() != null) {
			adminLog.setUser(accountService.getById(adminLog.getUserId()));
		}
	}

	public void buildDetail(List<AdminLog> adminLogs) {
		for (AdminLog adminLog : adminLogs) {
			buildDetail(adminLog);
		}
	}
}
