package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.UserBind;
import com.rocoinfo.rocomall.repository.account.UserBindDao;
import com.rocoinfo.rocomall.service.IUserBindService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <dl>
 * <dd>描述: 绑定服务</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月5日 上午11:15:17</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@Service
public class UserBindService extends CrudService<UserBindDao, UserBind> implements IUserBindService {

	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public StatusDto<String> bindUser(final UserBind userBind) {
		if (userBind == null || userBind.getOuid() == null || userBind.getPlatForm() == null || userBind.getUserId() == null) {
			return StatusDto.buildFailureStatusDto("绑定参数不合法");
		}

		Long boundedUserId = getBindUserIdByPlatformCodeAndOuid(userBind.getPlatForm().getCode(), userBind.getOuid());
		if (boundedUserId != null) {
			return StatusDto.buildFailureStatusDto(userBind.getPlatForm().getCode() + "的账户已经绑定过积分平台用户");
		}

		String boundedOuid = getBindOuidByPlatformCodeAndUserId(userBind.getPlatForm().getCode(), userBind.getUserId());
		if (!StringUtils.isEmpty(boundedOuid)) {
			return StatusDto.buildFailureStatusDto("您已有其它账号绑定到积分平台");
		}
		try {
			// 执行绑定逻辑
			this.entityDao.insert(userBind);
			// 查询匿名积分
			//			int anonyCent = this.centsDao.getAnonyCents(userBind);
			//			if (anonyCent > 0) {
			//				accountService.increaseGrowthById(userBind.getUserId(), anonyCent);
			//				this.centsDao.bindAnonyCents(userBind);
			//			}
			//			绑定成功后送积分
			//			centService.generateAndAddCent(DictPlan.BIND_REWARD_CENT_PLAN_CODE, userBind.getUserId());

			return StatusDto.buildSuccessStatusDto("账户绑定成功!");
		} catch (Exception e) {
			return StatusDto.buildFailureStatusDto("绑定失败，服务器内部错误，请联系管理员。");
		}

	}

	/**
	 * 返回是否已经绑定
	 */
	public boolean isBoundUserId(String platformCode, String ouid) {
		return this.entityDao.getBindUserIdByPlatformCodeAndOuid(platformCode, ouid) != null;
	}

	/**
	 * 返回用户开通的 已绑定的 其他平台列表
	 */
	public List<UserBind> findBoundOpenedPlatformByUserId(Long userId) {
		return this.entityDao.findBoundOpenedPlatformByUserId(userId);
	}

	/**
	 * 返回绑定的userId,如果尚未绑定，则返回null
	 */
	public Long getBindUserIdByPlatformCodeAndOuid(String platformCode, String ouid) {
		return this.entityDao.getBindUserIdByPlatformCodeAndOuid(platformCode, ouid);
	}

	/**
	 * 返回绑定的userId,如果尚未绑定，则返回null
	 */
	public Long getBindUserIdByPlatformIdAndOuid(Long platformId, String ouid) {
		return this.entityDao.getBindUserIdByPlatformIdAndOuid(platformId, ouid);
	}

	/**
	 * 返回已经绑定到其他平台的ouid,如果尚未绑定，则返回null
	 */
	public String getBindOuidByPlatformCodeAndUserId(String platformCode, Long userId) {
		return this.entityDao.getBindOuidByPlatformCodeAndUserId(platformCode, userId);
	}

	/**
	 * 返回已绑定的平台数
	 */
	public int countBoundedPlatformsByUserId(Long userId) {
		return this.entityDao.countBoundedPlatformsByUserId(userId);
	}
}
