package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.repository.account.UserDao;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.utils.PasswordUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * <dl>
 * <dd>描述: 会员Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月4日 上午10:14:48</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@Service
@Transactional
public class UserService extends CrudService<UserDao, User> implements IUserService {

    public User getUserByUsername(String username) {
        return entityDao.getByUsername(username);
    }

    public User getByMobile(String mobile) {
        return this.entityDao.getByMobile(mobile);
    }

    @Override
    public User getByUsername(String username) {
        return entityDao.getByUsername(username);
    }

    @Override
    public StatusDto register(User user) {
        if (StringUtils.isNotEmpty(user.getPlainPassword())) {
            PasswordUtil.entryptPassword(user);
        }
        user.setRegisterDate(new Date());
        user.setStatus(SwitchStatus.OPEN);
        this.entityDao.insert(user);
        return StatusDto.buildSuccessStatusDto("注册成功");
    }


}
