package com.rocoinfo.rocomall.service.impl.cent;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cent.CentConsumeDetail;
import com.rocoinfo.rocomall.entity.cent.CentConsumeRecord;
import com.rocoinfo.rocomall.repository.cent.CentConsumeDetailDao;
import com.rocoinfo.rocomall.repository.cent.CentConsumeRecordDao;
import com.rocoinfo.rocomall.service.cent.ICentConsumeRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;
import java.util.Map;


/**
 * weiys
 */
@Service
public class CentConsumeRecordService  extends CrudService<CentConsumeRecordDao,CentConsumeRecord> implements ICentConsumeRecordService{

	@Autowired
	private CentConsumeDetailDao centConsumeDetailDao;

	@Transactional
	public void save(CentConsumeRecord consumeRecord) {
		super.insert(consumeRecord);
		if (CollectionUtils.isNotEmpty(consumeRecord.getCentDetails())) {
			centConsumeDetailDao.insert(consumeRecord.getCentDetails());
		}
	}




	// 积分消耗明细
	public List<CentConsumeDetail> findCentConsumeDetailByRecordId(Long recordId) {
		return centConsumeDetailDao.findCentConsumeDetailByRecordId(recordId);
	}

	@Override
	public Page<CentConsumeRecord> searchScrollPageByRuleCode(Map<String,Object> params, PageRequest pageable) {
		params.put(Constants.PAGE_OFFSET, pageable.getPageNumber());
		params.put(Constants.PAGE_SIZE, pageable.getPageSize());
		params.put(Constants.PAGE_SORT, pageable.getSort());

		List<CentConsumeRecord> pageData = Collections.emptyList();
		Long count = this.entityDao.searchTotalByRuleCode(params);
		if (count > 0) {
			pageData = entityDao.searchByRuleCode(params);
		}
		return new PageImpl<CentConsumeRecord>(pageData, pageable, count);
	}

	// 积分消耗流水明细
	public List<CentConsumeDetail> findCentConsumeRecordAndDetailByCentId(Long centId) {
		return centConsumeDetailDao.findCentConsumeRecordAndDetailByCentId(centId);
	}
}
