package com.rocoinfo.rocomall.service.impl.cent;

import com.rocoinfo.rocomall.entity.cent.CentApply;
import com.rocoinfo.rocomall.entity.cent.CentApplyDetail;
import com.rocoinfo.rocomall.entity.cent.CentApprove;
import com.rocoinfo.rocomall.entity.cent.Cents;
import com.rocoinfo.rocomall.repository.cent.CentApplyDao;
import com.rocoinfo.rocomall.repository.cent.CentApplyDetailDao;
import com.rocoinfo.rocomall.repository.cent.CentApproveDao;
import com.rocoinfo.rocomall.repository.cent.CentsDao;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

import java.util.List;


/**
 * @author liuyang
 */
@SuppressWarnings("all")
@Service
@Transactional
public class CentImportService  {
	
	@Autowired
	private CentApplyDao centApplyDao;
	@Autowired
	private CentApplyDetailDao centApplyDetailDao;
	@Autowired
	private CentApproveDao centApproveDao;
	@Autowired
	private CentsDao centsDao;

	@Autowired
	private CentBudgetService centBudgetService;

	
	@Autowired
	private CodeGenerator codeGenerator;

	private static final int INSERT_MAX_RECORD = 1000;
	
	/**
	 * 检索积分申请信息(id)
	 */
	public CentApply getCentApplyById(Long id) {
		return null;
	}


	
	/**
	 * 检索积分申请详细信息(申请ID)
	 */
	public List<CentApplyDetail> findCentDetailInfoByApplyId(Long applyId) {
		return centApplyDetailDao.findCentDetailInfoByApplyId(applyId);
	}



	

	/**
	 * 删除积分申请详细信息(申请详细ID)
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void deleteCentDetailById(CentApplyDetail centApplyDetail) throws Exception {

		CentApplyDetail queryCentApplyDetail = centApplyDetailDao.getById(centApplyDetail.getId());
		CentApply queryCentApply = centApplyDao.getById(queryCentApplyDetail.getApplyId());
		
		centApplyDetailDao.deleteById(centApplyDetail.getId());
		
		if (CentApply.Type.ADD.equals(queryCentApply.getType())) {
			Cents cents = new Cents();
			cents.setStatus(Cents.Status.CANUSE);
			cents.setCode(queryCentApplyDetail.getCentCode());
			centsDao.update(cents);
		}
	}

	/**
	 * 删除积分申请详细信息(申请详细ID)
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void deleteCentApplyAllInfoById(Long id) throws Exception {

		CentApply queryCentApply = centApplyDao.getById(id);
		
		if (CentApply.Type.ADD.equals(queryCentApply.getType())) {
			List<CentApplyDetail> centApplyDetails = centApplyDetailDao.findCentDetailInfoByApplyId(id);

			for (CentApplyDetail centApplyDetail : centApplyDetails) {
				Cents cents = new Cents();
				cents.setStatus(Cents.Status.CANUSE);
				cents.setCode(centApplyDetail.getCentCode());
				centsDao.update(cents);
			}
		}
		
		centApplyDao.deleteById(id);
		centApplyDetailDao.deleteByApplyId(id);
	}
	
	/**
	 * 更新积分申请信息
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void updateApplyInfo(CentApply centApply) throws Exception {
		centApplyDao.update(centApply);

	}

	/**
	 * 更新积分申请信息,删除积分详细信息（积分减少）
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void updateCentSubstractInfo(CentApply centApply) throws Exception {
		centApplyDao.update(centApply);
	}

	/**
	 * 更新积分申请信息,更新积分详细信息（积分增加）
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void updateApplyAddInfo(CentApplyDetail postdata) throws Exception {
		CentApply centApply = new CentApply();
		centApply.setId(postdata.getApplyId());
		centApplyDao.update(centApply);
		centApplyDetailDao.update(postdata);
	}

	/**
	 * 提交审批
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void submitAudit(CentApply centApply) throws Exception {
		centApplyDao.update(centApply);
	}



	/**
	 * 否决审批
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void denyAudit(CentApprove centApprove) throws Exception {
		CentApply updateApplyState = new CentApply();

		centApproveDao.insert(centApprove);
		centApplyDao.update(updateApplyState);
		 
		CentApply centApply = centApplyDao.getById(updateApplyState.getId());

		if (CentApply.Type.ADD.equals(centApply.getType())) {
			List<CentApplyDetail> centApplyDetails = centApplyDetailDao.findCentDetailInfoByApplyId(updateApplyState.getId());
			centsDao.batchModifyCentStatus(Cents.Status.CANUSE,Collections3.extractToList(centApplyDetails, "centCode"));
		}
	}

	/**
	 * 退回审批
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void returnAudit(CentApprove centApprove) throws Exception {
		centApproveDao.insert(centApprove);

		CentApply centApply = new CentApply();
		centApplyDao.update(centApply);
	}

	/**
	 * 检索积分申请信息（申请编号）
	 */
	public CentApply getByApplyCode(String applyCode) {
		return null;
	}


}