package com.rocoinfo.rocomall.service.impl.cfg;

import com.fasterxml.jackson.databind.JavaType;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cfg.SigninRuleCfg;
import com.rocoinfo.rocomall.entity.cfg.SigninRuleCfg.CentCfgItem;
import com.rocoinfo.rocomall.repository.cfg.SigninRuleCfgDao;
import com.rocoinfo.rocomall.service.cfg.ISigninRuleCfgService;
import com.rocoinfo.rocomall.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * <dl>
 * <dd>描述: 签到规则配置 Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年12月15日 下午2:47:44</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@Service
@SuppressWarnings("unchecked")
public class SigninRuleCfgService extends CrudService<SigninRuleCfgDao, SigninRuleCfg> implements ISigninRuleCfgService {

	/**
	 * 获得系统唯一的签到规则,系统中只有一个签到规则配置
	 */
	public SigninRuleCfg getUniqueSigninRule() {
		SigninRuleCfg signRule = this.entityDao.getUniqueSigninRule();
		if (signRule != null) {
			List<CentCfgItem> cfgItemList = Collections.emptyList();
			if (StringUtils.isNotBlank(signRule.getCentCfgJson())) {
				JavaType javaType = JsonUtils.normalMapper.contructCollectionType(List.class, CentCfgItem.class);
				cfgItemList = (List<CentCfgItem>) JsonUtils.fromJson(signRule.getCentCfgJson(), javaType);
			}
			signRule.setCfgItemList(cfgItemList);
		}
		return signRule;
	}
}
