package com.rocoinfo.rocomall.service.impl.dict;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.dict.DictCentConsumeType;
import com.rocoinfo.rocomall.repository.dict.DictCentConsumeTypeDao;
import com.rocoinfo.rocomall.service.dict.IDictCentConsumeTypeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DictCentConsumeTypeService extends CrudService<DictCentConsumeTypeDao, DictCentConsumeType> implements IDictCentConsumeTypeService {

	public boolean isExistCode(final String centCosumeTypeCode) {
		if (StringUtils.isBlank(centCosumeTypeCode)) {
			return false;	
		}
		for (DictCentConsumeType cenc : findAll()) {
			if (cenc != null && cenc.getCode().equalsIgnoreCase(centCosumeTypeCode)) {
				return true;
			}
		}
		return false;
	}

	public boolean isExistName(final String centCosumeTypeName) {
		if (StringUtils.isBlank(centCosumeTypeName)) {
			return false;
		}

		for (DictCentConsumeType consumeType : findAll()) {
			if (consumeType.getName().equalsIgnoreCase(centCosumeTypeName)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public void insert(DictCentConsumeType entity) {
		if (isExistCode(entity.getCode())) {
			throw new ServiceException("消耗类型已存在");
		}

		if (isExistName(entity.getName())) {
			throw new ServiceException("消耗类型名称已存在");
		}
		super.insert(entity);
	}

	@Override
	public void update(DictCentConsumeType centConsumeType) {
		DictCentConsumeType oldConsumeType = getById(centConsumeType.getId());
		if (!oldConsumeType.getName().equalsIgnoreCase(centConsumeType.getName()) && isExistName(centConsumeType.getName())) {
			throw new ServiceException("消耗类型名称已存在,请换个名称!");
		}
		super.update(centConsumeType);
	}
}