package com.rocoinfo.rocomall.service.impl.dict;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.dict.DictSkuMeta;
import com.rocoinfo.rocomall.repository.dict.DictSkuMetaDao;
import com.rocoinfo.rocomall.service.dict.IDictSkuMetaService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DictSkuMetaService extends CrudService<DictSkuMetaDao, DictSkuMeta> implements IDictSkuMetaService {

	@Override
	public void insert(DictSkuMeta entity) {
		if (isExistName(entity.getName())) {
			throw new ServiceException("名称已经存在");
		}
		if (isExistDisPlayName(entity.getName())) {
			throw new ServiceException("显示名称已经存在");
		}
		super.insert(entity);
	}

	@Override
	public void update(DictSkuMeta entity) {
		DictSkuMeta dbentity = this.getById(entity.getId());
		if (dbentity == null) {
			throw new ServiceException("数据不存在");
		}
		if (!StringUtils.equals(entity.getName(), dbentity.getName())) {
			if (isExistName(entity.getName())) {
				throw new ServiceException("名称已经存在");
			}
		}

		if (!StringUtils.equals(entity.getDisplayName(), dbentity.getDisplayName())) {
			if (isExistDisPlayName(entity.getName())) {
				throw new ServiceException("显示名称已经存在");
			}
		}
		super.update(entity);
	}

	private boolean isExist(DictSkuMeta dictSkuMeta) {
		return this.entityDao.countMeta(dictSkuMeta) > 0;
	}

	private boolean isExistName(String name) {
		DictSkuMeta dictSkuMeta = new DictSkuMeta();
		dictSkuMeta.setName(name);
		return isExist(dictSkuMeta);
	}

	private boolean isExistDisPlayName(String disPlayname) {
		DictSkuMeta dictSkuMeta = new DictSkuMeta();
		dictSkuMeta.setDisplayName(disPlayname);
		return isExist(dictSkuMeta);
	}
}
