package com.rocoinfo.rocomall.service.impl.order;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.order.OrderDelivery;
import com.rocoinfo.rocomall.repository.order.OrderDeliveryDao;
import com.rocoinfo.rocomall.service.order.IOrderDeliveryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * <dl>
 * <dd>描述: 订单地址service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/11/12 下午14:37</dd>
 * <dd>创建人： Johnny</dd>
 * </dl>
 */
@SuppressWarnings("all")
@Service
public class OrderDeliveryService extends CrudService<OrderDeliveryDao, OrderDelivery> implements IOrderDeliveryService {

	@Value("${addr.recipient.deny.chars}")
	private String recipientDenyChars;

	@Value("${addr.detail.mustcontain.chars}")
	private String addrMustContainChars;

	@Value("${addr.detail.deny.chars}")
	private String addrDenyChars;

	@Override
	public OrderDelivery getByOrderId(long orderId) {
		return super.entityDao.getByOrderId(orderId);
	}

	/**
	 * 检验是否是合法的 收货地址
	 */
	public boolean isValid(OrderDelivery delivery) {
		String address = delivery.getAddrDetail();
		if (address == null || address.length() < 5 || StringUtils.isEmpty(delivery.getProvince()) || StringUtils.isEmpty(delivery.getCity()) || StringUtils.isEmpty(delivery.getCounty())) {
			return false;
		}

		if (StringUtils.containsAny(delivery.getRecipient(), recipientDenyChars)) {
			return false;
		}

		String addrDenyPattern = ".*(" + addrDenyChars + ").*";
		String addMustContainPattern = ".*(" + addrMustContainChars + ").*";
		String containDigitalPattern = ".*\\d+.*";

		if (address.matches(addrDenyPattern)) {
			return false;
		}

		if (!address.matches(addMustContainPattern)) {
			return false;
		}

		//合格的地址：如果包括数字 就必须包含“公司、政府、局、学校、大厦、酒店、医院”中的一个字符
		if (!(address.matches(containDigitalPattern) && address.matches(".*(公司|政府|局|学校|大厦|酒店|医院).*"))) {
			return false;
		}
		return true;
	}
}
