package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Description;
import com.rocoinfo.rocomall.repository.DescriptionDao;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.service.product.IDescriptionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liuwei
 */
@SuppressWarnings("all")
@Service
public class DescriptionService extends CrudService<DescriptionDao, Description> implements IDescriptionService {
	@Autowired
	private UploadService uploadService;

	public void insert(Description description) {
		description.setIntroduction(uploadService.submitHtml(description.getIntroduction()));
		description.setSpecification(uploadService.submitHtml(description.getSpecification()));
		description.setPackingList(uploadService.submitHtml(description.getPackingList()));
		description.setAfterSale(uploadService.submitHtml(description.getAfterSale()));
		super.insert(description);
	}

	public void update(Description description) {
		if (description.getIntroduction() != null || description.getAfterSale() != null || description.getPackingList() != null
				|| description.getSpecification() != null) { // 可能所有内容都为null，那样的话update会报错

			Description oldDescription = entityDao.findByProductId(description.getProductId());
			if (description.getIntroduction() != null) {
				description.setIntroduction(uploadService.updateHtml(oldDescription.getIntroduction(), description.getIntroduction()));
			}
			if (description.getSpecification() != null) {
				description.setSpecification(uploadService.updateHtml(oldDescription.getSpecification(), description.getSpecification()));
			}
			if (description.getPackingList() != null) {
				description.setPackingList(uploadService.updateHtml(oldDescription.getPackingList(), description.getPackingList()));
			}
			if (description.getAfterSale() != null) {
				description.setAfterSale(uploadService.updateHtml(oldDescription.getAfterSale(), description.getAfterSale()));
			}

			super.update(description);
		}
	}

	public void delete(Long productId) {
		Description description = findByProductId(productId);
		super.deleteById(productId);
		uploadService.deleteByPathInHtml(description.getIntroduction());
		uploadService.deleteByPathInHtml(description.getSpecification());
		uploadService.deleteByPathInHtml(description.getPackingList());
		uploadService.deleteByPathInHtml(description.getAfterSale());
	}

	public Description findByProductId(Long productId) {
		return entityDao.findByProductId(productId);
	}
}
