package com.rocoinfo.rocomall.service.impl.product;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.ProdComment;
import com.rocoinfo.rocomall.repository.ProdCommentDao;
import com.rocoinfo.rocomall.service.product.IProdCommentService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;


@Service
@Transactional
public class ProdCommentServiceImp extends CrudService<ProdCommentDao, ProdComment> implements IProdCommentService {

    @Override
    public List<ProdComment> findByProductIdScrollPage(Long productId, Long page) {
        if (productId == null)
            return null;
        Map<String, Object> params = Maps.newHashMap();
        // 分页信息
        params.put(Constants.PAGE_OFFSET, Constants.DEFAULT_PAGE_SIZE * page);
        params.put(Constants.PAGE_SIZE, Constants.DEFAULT_PAGE_SIZE);

        params.put("productId", productId);

        return this.entityDao.findByProductIdScrollPage(params);
    }
}