package com.rocoinfo.rocomall.service.impl.product;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.redis.CacheKeys;
import com.rocoinfo.rocomall.repository.SupplierDao;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-3 下午1:33:28</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@SuppressWarnings("all")
@Service
public class SupplierService extends CrudService<SupplierDao, Supplier> implements ISupplierService {

	public List<Supplier> findSuppliers(Boolean useable) {
		List<Supplier> supplierList = Lists.newArrayList();
		List<Supplier> all = getProxy().findAll();
		if (useable == null) {
			supplierList = all;
		} else {
			for (Supplier supplyer : all) {
				if (supplyer.getUseable().equals(useable)) {
					supplierList.add(supplyer);
				}
			}
		}
		return supplierList;
	}

	@Override
	@Cacheable(value = CacheKeys.DEFAULT_NAME, key = CacheKeys.SUPPLIER_ALL_KEY)
	public List<Supplier> findAll() {
		return super.findAll();
	}

	@Override
	protected void evictCacheEntitysHook() {
		Cache cache = cacheManager.getCache(CacheKeys.DEFAULT_NAME);
		cache.evict(StringUtils.substringBetween(CacheKeys.SUPPLIER_ALL_KEY, "'"));
	}

	@Override
	public void insert(Supplier entity) {
		if (isExitCode(entity.getCode())) {
			throw new ServiceException("供应商编码已经存在");
		}
		if (isExitName(entity.getName())) {
			throw new ServiceException("供应商名称已经存在");
		}
		entity.setUseable(true);
		super.insert(entity);
	}

	@Override
	public void update(Supplier entity) {
		Supplier dbsupplier = getById(entity.getId());
		if (StringUtils.isNotEmpty(entity.getCode()) && !StringUtils.equalsIgnoreCase(entity.getCode(), dbsupplier.getCode())) {
			if (isExitCode(entity.getCode())) {
				throw new ServiceException("供应商编码已经存在");
			}
		}
		if (StringUtils.isNotEmpty(entity.getName()) && !StringUtils.equalsIgnoreCase(entity.getName(), dbsupplier.getName())) {
			if (isExitName(entity.getName())) {
				throw new ServiceException("供应商名称已经存在");
			}
		}
		super.update(entity);
	}

	private boolean isExitCode(String code) {
		return this.entityDao.isExitCode(code) > 0;
	}

	private boolean isExitName(String name) {
		return entityDao.isExitName(name) > 0;
	}

	/**
	 * 查询管理员能够管理的供应商(状态是合作的)
	 */
	public List<Supplier> findUseableSupplysByAdminId(Long adminId) {
		return entityDao.findUseableSupplysByAdminId(adminId);
	}

	private SupplierService getProxy() {
		return (SupplierService) AopContext.currentProxy();
	}

}
