package com.rocoinfo.rocomall.service.impl.workorder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.workorder.WorkOrderRefundDetail;
import com.rocoinfo.rocomall.repository.workorder.WorkOrderRefundDetailDao;
import com.rocoinfo.rocomall.service.impl.order.OrderItemService;
import com.rocoinfo.rocomall.service.workorder.IWorkOrderRefundDetailService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:客服工单退货记录 服务</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月20日11:37:37</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
@Service
public class WorkOrderRefundDetailService extends CrudService<WorkOrderRefundDetailDao, WorkOrderRefundDetail> implements IWorkOrderRefundDetailService {

	@Autowired
	private OrderItemService orderItemService;

	/**
	 * 统计退货工单 尚未确认收货的入库单数量
	 */
	public Map<Long, Integer> countUnReceiveNumOfWorkOrder(List<Long> workOrderIdList) {
		if (CollectionUtils.isEmpty(workOrderIdList)) {
			return Collections.emptyMap();
		}

		//Map<工单Id,未确认收货的入库单数量>
		Map<Long, Integer> unReceiveNumMap = Maps.newHashMap();
		List<Map<String, Object>> rowItemList = this.entityDao.countUnReceiveNumOfWorkOrder(workOrderIdList);
		for (Map<String, Object> rowItem : rowItemList) {
			Integer workOrderId = (Integer) rowItem.get("workOrderId");
			int num = ((BigDecimal) rowItem.get("unConfirmReceiveNum")).intValue();
			unReceiveNumMap.put(Long.valueOf(workOrderId), num);
		}
		return unReceiveNumMap;
	}

	/**
	 * 通过工单Id获取退货明细(包括的子订单信息也一起查询出来)
	 */
	public List<WorkOrderRefundDetail> findByWorkOrderId(final Long workOrderId) {
		if (workOrderId == null || workOrderId < 1)
			return Collections.emptyList();
		return this.entityDao.findByWorkOrderId(workOrderId);
	}

	@Transactional
	public void saveWorkOrderRefundDetails(List<WorkOrderRefundDetail> refundDetailList) {
		if (CollectionUtils.isNotEmpty(refundDetailList)) {
			List<Long> subOrderIdList = Lists.newArrayList();
			for (WorkOrderRefundDetail item : refundDetailList) {
				this.insert(item);
				subOrderIdList.add(item.getOrderItem().getId());
			}
			orderItemService.batchUpdateStatus(OrderItem.Status.REFUND_ACCEPT, OrderItem.AdmStatus.REFUND_ACCEPT, subOrderIdList);
		}
	}
}
