package com.rocoinfo.rocomall.service.impl.workorder;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.order.InstoreOrder;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.workorder.WorkOrder;
import com.rocoinfo.rocomall.entity.workorder.WorkOrderRefundDetail;
import com.rocoinfo.rocomall.repository.workorder.WorkOrderDao;
import com.rocoinfo.rocomall.service.impl.order.InstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.workorder.IWorkOrderRefundDetailService;
import com.rocoinfo.rocomall.service.workorder.IWorkOrderService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * <dl>
 * <dd>描述:客服工单 服务</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月18日 上午10:34:59</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
@Service
public class WorkOrderService extends CrudService<WorkOrderDao, WorkOrder> implements IWorkOrderService {

	@Autowired
	private IOrderItemService orderItemService;
	@Autowired
	private IWorkOrderRefundDetailService workOrderRefundDetailService;
	@Autowired
	private CodeGenerator codeGenerator;
	@Autowired
	private InstoreOrderService instoreOrderService;

	/**
	 * 工单结案
	 * 
	 * @param workOrder 工单
	 */
	@Transactional
	public void closeWorkOrder(WorkOrder workOrder) {
		if (workOrder != null) {
			this.entityDao.update(workOrder);

			if (WorkOrder.Type.REFUND.equals(workOrder.getType())) {
				//点击“结案”按钮时，如果是退货工单,自动返还用户积分，对应的子订单的订单状态改为“已退货”,订单内部状态改为“已退货”
				List<WorkOrderRefundDetail> refundDetailList = workOrderRefundDetailService.findByWorkOrderId(workOrder.getId());
				if (CollectionUtils.isNotEmpty(refundDetailList)) {
					int refundCentTotal = 0;
					double refundAmtTotal = 0;
					List<Long> orderItemIdList = Lists.newArrayList();

					for (WorkOrderRefundDetail detail : refundDetailList) {
						orderItemIdList.add(detail.getOrderItem().getId());
						refundCentTotal += detail.getCent();
						refundAmtTotal += detail.getAmount();
					}

					orderItemService.batchUpdateStatus(OrderItem.Status.REFUNDED, OrderItem.AdmStatus.REFUNDED, orderItemIdList);

					//FIXME TODO 退积分 和退现金操作
				}
			}
		}
	}

	/**
	 * 生成退货工单的 入库通知单 & 更新子订单状态为 “退货已输入物流单号”
	 * 
	 * @param workOrder
	 * @param operator 入库操作人
	 */
	@Transactional
	public void generateRefundInstoreOrders(WorkOrder workOrder, AdminUser operator) {
		DictExpress express = workOrder.getExpress();
		//如果输入了运单号,则生成 退货入库单
		if (WorkOrder.Type.REFUND.equals(workOrder.getType()) && express != null && express.getId() > 0 && StringUtils.isNotBlank(workOrder.getTransportNo())) {

			List<Long> orderItemIdList = Lists.newArrayList();
			List<WorkOrderRefundDetail> refundDetailList = workOrderRefundDetailService.findByWorkOrderId(workOrder.getId());
			for (WorkOrderRefundDetail detail : refundDetailList) {

				orderItemIdList.add(detail.getOrderItem().getId());

				InstoreOrder inStoreOrder = new InstoreOrder();
				inStoreOrder.setCode(this.codeGenerator.generateInstoreOrderCode());
				inStoreOrder.setCreateTime(new Date());
				inStoreOrder.setInType(InstoreOrder.InstoreType.REFUND);

				String note = InstoreOrder.InstoreType.REFUND.getLabel() + ",工单号:" + workOrder.getCode() + ",退货子订单号:" + detail.getOrderItem().getOrderCode();
				inStoreOrder.setNote(note);
				inStoreOrder.setOperator(operator);
				inStoreOrder.setQuantity(detail.getQuantity());
				inStoreOrder.setReceiveState(InstoreOrder.ReceiveStatus.UNFINISHED);
				inStoreOrder.setSku(detail.getSku());
				inStoreOrder.setWarehouse(detail.getWarehouse());
				inStoreOrder.setOrderCode(detail.getOrderItem().getOrderCode());
				inStoreOrder.setRefundDetailId(detail.getId());
				// 插入  退货入库单
				instoreOrderService.insert(inStoreOrder);
			}

			//更新订单状态 （退货中 & 退货已输入物流单号）
			orderItemService.batchUpdateStatus(OrderItem.Status.REFUNDED, OrderItem.AdmStatus.REFUNDED, orderItemIdList);
		}
	}
}
