package com.rocoinfo.rocomall.service.order;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.order.DistributionOrder;
import com.rocoinfo.rocomall.entity.order.MergeDistributeOrder;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: 配送单</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月16日 上午11:39:27</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public interface IDistributionOrderService extends IBaseService<DistributionOrder> {

	/**
	 * 通过Id获取配送单,包括关联的订单Item，订单的配送地址信息一起查询出来
	 * 
	 * @param distriOrderIdList 配送单Id列表
	 */
	public List<DistributionOrder> findDistributeOrderWithItemAddrByIdIn(List<Long> distriOrderIdList);

	/**
	 * 通过合并号 获得配送单Ids
	 * 
	 * @param mergeCode
	 */
	public List<Long> findDistributeOrderIdsByMergeCode(final String mergeCode);

	/**
	 * 生成配送单 并更新订单为已配送
	 * 
	 * @param order 主订单：必须包含订单Item 和item对应的sku
	 */
	public void generateDistributeOrder(Order order);

	/**
	 * 生成出库单
	 */
	public void generateOutstoreOrder(List<DistributionOrder> distriOrderList, Long operatorId);

	/**
	 * 合并/拆分 配送单
	 * 
	 * @param distriOrderIdList
	 * @param mergeCode mergeCode为空表示拆分,不空表示合并
	 */
	public void mergeOrSplit(List<Long> distriOrderIdList, String mergeCode);

	/**
	 * 导入 物流单号 并更新相应的订单状态为“配送中”
	 */
	public void importLogistics(List<DistributionOrder> distriOrderList);

	/**
	 * 搜索符合 合并条件的 配送单
	 */
	public Page<MergeDistributeOrder> searchMergeDistributeOrder(Map<String, Object> params, Pageable pageable);
	
	/**
	 * 更新子订单状态
	 * @param distriOrderList
	 * @param status
	 * @param admStatus
	 * 2015年12月3日 下午4:18:48
	 */
	public void updateOrderItemStatus(List<DistributionOrder> distriOrderList,OrderItem.Status status, OrderItem.AdmStatus admStatus);

}
