package com.rocoinfo.rocomall.service.order;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.OrderBitchSendImportExcelDto;
import com.rocoinfo.rocomall.dto.admin.OrderItemExchageRefundParamDto;
import com.rocoinfo.rocomall.entity.OrderItemOperationLog;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: 子订单service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/7/30 下午1:36</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
public interface IOrderItemService extends IBaseService<OrderItem> {

    /**
     * 更据总订单id查找子订单
     *
     * @param orderId
     * @return
     */
    public List<OrderItem> findByOrderId(Long orderId);

    /**
     * 根据子订单id查询并带出快递公司信息
     *
     * @param id
     * @return
     */
    public OrderItem getSaleItemWithExpressById(Long id);

    /**
     * 更改子订单的快递公司和运单号
     *
     * @param expressId
     * @param transportNo
     * @param orderItemId
     */
    public void updateExpressAndTransportNoById(final long expressId, String transportNo, final long orderItemId);

    /**
     * 根据主订单id查找子订单并带出sku信息
     *
     * @param orderIdList
     * @return
     */
    public List<OrderItem> findWithSkuByOrderIdsIn(List<Long> orderIdList);

    /**
     * 分业查询子订单列表
     *
     * @param params
     * @param pageable
     * @return
     */
    public Page<OrderItem> adminSearch(Map<String, Object> params, Pageable pageable);

    /**
     * 导出订单excel查询
     *
     * @param params
     * @return
     */
    public List<OrderItem> adminExportSearch(Map<String, Object> params);

    /**
     * 取消总订单
     *
     * @param orderId               总订单号
     * @param loggedUserId          操作人
     * @param isReleaseOccupedStock 释放需要释放占用库存
     */
    public void cancelOrder(final long orderId, Long loggedUserId, boolean isReleaseOccupedStock);

    /**
     * 取消子订单
     *
     * @param orderItemId
     * @param loggedUserId
     */
    public void cancelOrderItem(final long orderItemId, Long loggedUserId);

    /**
     * 发货
     *
     * @param sendOrder
     * @param loggedUserId
     */
    public void sendOrder(OrderItem sendOrder, Long loggedUserId);

    /**
     * 重新发货
     *
     * @param orderItemId
     */
    public void repeatSendOrder(long orderItemId);

    /**
     * 处理子订单
     *
     * @param isBatch
     * @param orderItemIds
     */
    public void dealWithOrderItems(boolean isBatch, AdminUser operator, Long... orderItemIds);

    /**
     * 订单确认收货|换货完成|退货完成
     *
     * @param orderItemId
     * @param newStatus
     * @param loggedUserId
     */
    public void updateOrderState(long orderItemId, OrderItem.Status newStatus, OrderItem.AdmStatus admStatus, Long loggedUserId);

    /**
     * 根据订单编号数组，查询已处理状态的子订单
     *
     * @param orderCodes
     * @return
     */
    public List<OrderItem> findDealedOrderItemsByCodesIn(List<String> orderCodes);

    /**
     * 换货
     *
     * @param exchageParamDto
     */
    @Deprecated
    public void exchangeSalesOrderItems(OrderItemExchageRefundParamDto exchageParamDto) throws Exception;

    /**
     * 退化
     *
     * @param refundParamDto
     */
    @Deprecated
    public void doRefundSalesOrderItems(final OrderItemExchageRefundParamDto refundParamDto) throws Exception;

    /**
     * 查询子订单操作记录
     *
     * @param orderItemId
     * @return
     */
    public List<OrderItemOperationLog> findOperationLogByOrderItemId(Long orderItemId);

    /**
     * 构建订单项的详情
     */
    public void buildDetail(OrderItem orderItem);

    /**
     * 批量发货更新订单状态
     */
    @Deprecated
    public void updateSalesOrderItemsForBitchSend(final List<OrderBitchSendImportExcelDto> canSendOrderDtos, AdminUser loginedUserId);

    /**
     * 发货导出
     *
     * @param file
     * @param adminUser
     * @param response
     * @return
     * @author： 张文山
     */
    public StatusDto importToSend(List<OrderBitchSendImportExcelDto> orderSendList, AdminUser operator);

    /**
     * 根据用户id查询用户订单状态和订单数量 Map<订单状态,订单数量>
     *
     * @param id
     */
    Map<String, Long> statisOrderNumGroupByStatus(Long userId);

    /**
     * 批量插入
     *
     * @param items
     */
    void insertItems(List<OrderItem> items);

    /**
     * 批量更新子订单状态
     *
     * @param outStatus
     * @param inStatus
     * @param ids
     */
    void batchUpdateStatus(OrderItem.Status outStatus, OrderItem.AdmStatus inStatus, List<Long> ids);

    /**
     * 根据订单id查询第一条子订单的记录
     *
     * @param orderId
     * @return
     */
    OrderItem getFirstByOrderId(Long orderId);
}
