package com.rocoinfo.rocomall.service.order;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.order.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: 总订单service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/7/30 下午1:36</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
public interface IOrderService extends IBaseService<Order> {

	/**
	 * 释放或占用订单的“占用库存”
	 * 
	 * @param operateFlag 操作标记 1：释放库存，2：占用库存
	 */
	public void releaseOrOccupyStockByOrderId(Long orderId, int operateFlag);

	/**
	 * 根据订单编号查询订单
	 * 
	 * @param orderNo
	 * @return
	 */
	public Order getByOrderNo(final String orderNo);

	/**
	 * 保存购物车订单
	 */
	void saveCartOrder(Order order, Long loggedUserId);
	
	/**
	 * 查询订单详情
	 * @param parameters 查询条件
	 * @param pageable 分页参数
	 * @return
	 */
	Page<Order> searchOrder(Map<String, Object> parameters, PageRequest pageable);
	
	/**
	 * 构建订单详情
	 * @param orderList 订单list
	 * @param isLoadImg 是否加载商品图片
	 * @param params 参数，包括status
	 */
	public void buildOrderItems(List<Order> orderList,boolean loadImg,Map<String,Object> params);

}
