package com.rocoinfo.rocomall.service.product;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.ProdTemp;
import com.rocoinfo.rocomall.entity.Product;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-7-31 下午6:21:25</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public interface IProductService extends IBaseService<Product> {

    /**
     * 创建商品
     *
     * @创建时间：2015-7-31 下午6:22:33
     */
    void create(Product product, Long userId);

    /**
     * 保存零时商品数据
     */
    Long createTemp(String jsonStr, Long userId);

    /**
     * 更新商品
     *
     * @创建时间：2015-7-31 下午6:22:41
     */
    void update(Product product, Long userId);

    /**
     * 更新零时商品数据
     *
     * @创建时间：2015-7-31 下午6:22:41
     */
    void updateTemp(String jsonStr, Long id);

    // 弃用
    void discard(long id, Long userId);

    // 提交审核
    void submitAudit(Long id, Long userId);

    // 审核拒绝
    void auditRefuse(Long id, Long userId);

    // 审核通过
    void auditOk(Long id, Long userId);

    // 上架
    void list(Long id, Long userId) throws Exception;

    // 下架
    void delist(Long id, Long userId);

    // 建立详情
    void buildDetail(Product product);

    ProdTemp getLastProdTempByUserId(Long userId);

    List<Long> scheduleList();

    List<Long> scheduleDelist();

    /**
     * 分页查询商品信息(带主图信息)
     *
     * @param params 查询参数
     * @param page   起始页数(默认每页10条)
     * @return
     */
    List<Product> searchWithMainImg(Map<String, Object> params, int page);
}
