package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.Constants;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;

import java.io.*;
import java.util.Map;

public class VelocityUtils {

	/**
	 * 渲染模板内容.
	 * 
	 * @param templateContent 模板内容.
	 * @param data 变量Map.
	 */
	public static String renderTemplateContent(String templateContent, Map<String, ?> data) {
		if (data == null || data.isEmpty()) {
			return templateContent;
		}

		VelocityContext velocityContext = new VelocityContext(data);
		StringWriter result = new StringWriter();
		try {
			Velocity.evaluate(velocityContext, result, StringUtils.EMPTY, templateContent);
		} catch (Exception e) {
		}
		return result.toString();
	}

	/**
	 * 渲染模板文件.
	 * 
	 * @param velocityEngine velocityEngine, 需经过VelocityEngineFactory处理, 绑定Spring的ResourceLoader.
	 * @param templateContent 模板文件名, loader会自动在前面加上velocityEngine的resourceLoaderPath.
	 * @param context 变量Map.
	 */
	public static String renderFile(String templateFilePName, VelocityEngine velocityEngine, String encoding, Map<String, ?> context) {
		VelocityContext velocityContext = new VelocityContext(context);
		StringWriter result = new StringWriter();
		try {
			velocityEngine.mergeTemplate(templateFilePName, encoding, velocityContext, result);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result.toString();
	}

	/**
	 * @data 要替换的值
	 * @param vmFileRelatePath 模板文件相对路径,相对于模板环境的基准路径，例如：news/arrangement.vm
	 */
	public static void generateHTML(Map<String, ?> data, final String vmFileRelatePath, File staticHtmlFile) {
		try {
			VelocityContext context = new VelocityContext(data);
			Template template = Velocity.getTemplate(vmFileRelatePath);
			File saveDir = staticHtmlFile.getParentFile();
			if (!saveDir.exists())
				saveDir.mkdirs();
			BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(staticHtmlFile), Constants.DEFAULT_ENCODING));
			template.merge(context, writer);
			writer.flush();
			writer.close();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
