package com.rocoinfo.rocomall.dto;

import com.rocoinfo.rocomall.entity.Catalog;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CatalogTreeDto {

	private Long id;

	private Map<String, Integer> a_attr = new HashMap<String, Integer>();

	private List<CatalogTreeDto> children;

	// 显示树形结构需要的属性
	private String text;

	public List<CatalogTreeDto> getChildren() {
		return children;
	}

	public void setChildren(List<CatalogTreeDto> children) {
		this.children = children;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Map<String, Integer> getA_attr() {
		return a_attr;
	}

	public void setLevel(int level) {
		a_attr.put("data-lev", level);
	}

	public static CatalogTreeDto constructTree(CatalogTreeDto curCode, List<Catalog> orgList, int level) {
		if (CollectionUtils.isEmpty(orgList) || curCode == null) {
			return null;
		}

		List<CatalogTreeDto> childNodeList = new ArrayList<CatalogTreeDto>();

		// 构造根节点
		Catalog org = null;
		for (int index = 0; index < orgList.size(); index++) {
			org = orgList.get(index);
			if (org == null) {
				continue;
			}
			if (curCode.getId().equals(org.getParentId())) {
				CatalogTreeDto childNode = new CatalogTreeDto();
				childNode.setId(org.getId());
				childNode.setText(org.getName());
				childNode.setLevel(level);
				childNodeList.add(childNode);
			}
		}
		if (CollectionUtils.isNotEmpty(childNodeList)) {
			// 设置子节点
			curCode.setChildren(childNodeList);
		}
		// 递归构造子节点
		level++;
		for (CatalogTreeDto dto : childNodeList) {
			constructTree(dto, orgList, level);
		}
		return curCode;
	}
}
