package com.rocoinfo.rocomall.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * 物流跟踪信息
 *
 * @author zhangmin
 */
public class LogisticTrack {

    /**
     * 运单号
     */
    private String logisticsNo;

    /**
     * 跟踪items
     */
    @JsonProperty(value = "logisticsItems")
    private List<LogisticTrackItem> trackItems;

    public static class LogisticTrackItem {

        private String date;  //2011-01-05 20:58:12

        private String desc;  //已取件，到达 [上海_孙桥营业所]

        public String getDate() {
            return date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public String getLogisticsNo() {
        return logisticsNo;
    }

    public void setLogisticsNo(String logisticsNo) {
        this.logisticsNo = logisticsNo;
    }

    public List<LogisticTrackItem> getTrackItems() {
        return trackItems;
    }

    public void setTrackItems(List<LogisticTrackItem> trackItems) {
        this.trackItems = trackItems;
    }
}