package com.rocoinfo.rocomall.dto.admin;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.order.OrderItem;

/**
 * <dl>
 * <dd>Description:订单详情的dto</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016年8月14日 下午3:39:05</dd>
 * <dd>@author：Kong</dd>
 * </dl>
 */
public class OrderDetailsDto implements Serializable{

	/**
	 * OrderDetailsDto serialVersionUID
	 */
	private static final long serialVersionUID = 6873426352343796458L;
	
	/**
	 * 收货人信息，姓名，手机号，地址信息
	 */
	private Map<String,Object> address;
	
	/**
	 * 订单id
	 */
	private Long orderId;
	
	/**
	 * 主订单号
	 */
	private String orderCode;
	
	/**
	 * 子订单列表
	 */
	private List<Map<String,Object>> items;
	
	/**
	 * 创建时间
	 */
	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
	private Date createTime;
	
	/**
	 * 订单总额
	 */
	private Double amount;
	
	/**
	 * 订单状态
	 */
	private OrderItem.Status status;

	public Map<String, Object> getAddress() {
		return address;
	}

	public void setAddress(Map<String, Object> address) {
		this.address = address;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public List<Map<String, Object>> getItems() {
		return items;
	}

	public void setItems(List<Map<String, Object>> items) {
		this.items = items;
	}

	
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	
	public Double getAmount() {
		return amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public OrderItem.Status getStatus() {
		return status;
	}

	public void setStatus(OrderItem.Status status) {
		this.status = status;
	}

	public static class Builder{
		/**
		 * 收货人信息，姓名，手机号，地址信息
		 */
		private Map<String,Object> address;
		
		/**
		 * 订单id
		 */
		private Long orderId = 0l;
		
		/**
		 * 主订单号
		 */
		private String orderCode;
		
		/**
		 * 子订单列表
		 */
		private List<Map<String,Object>> items;
		
		/**
		 * 创建时间
		 */
		private Date createTime;
		
		/**
		 * 订单总额
		 */
		private Double amount = 0.0;
		
		/**
		 * 订单状态
		 */
		private OrderItem.Status status;
		
		public Builder(Long orderId, String orderCode){
			this.orderId = orderId;
			this.orderCode = orderCode;
		}


		public Builder address(Map<String, Object> address) {
			this.address = address;
			return this;
		}

		public Builder items(List<Map<String, Object>> items) {
			this.items = items;
			return this;
		}

		public Builder createTime(Date createTime) {
			this.createTime = createTime;
			return this;
		}


		public Builder amount(Double amount) {
			this.amount = amount;
			return this;
		}


		public Builder status(OrderItem.Status status) {
			this.status = status;
			return this;
		}
		
		
		public OrderDetailsDto build(){
			return new OrderDetailsDto(this);
		}
		
	}
	
	public OrderDetailsDto(){}
	
	
	private OrderDetailsDto(Builder builder){
		address = builder.address;
		
		orderId = builder.orderId;
		
		orderCode = builder.orderCode;
		
		items = builder.items;
		
		createTime = builder.createTime;
		
		amount = builder.amount;
		
		status = builder.status;
	}
}

