package com.rocoinfo.rocomall.dto.admin;

import com.rocoinfo.rocomall.entity.order.OrderItem;

import java.io.Serializable;

/**
 * <dl>
 * <dd>Description:订单列表信息的Dto</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016年8月14日 下午5:47:32</dd>
 * <dd>@author：Kong</dd>
 * </dl>
 */
public class OrderListDto implements Serializable{

	/**
	 * OrderListDto serialVersionUID
	 */
	private static final long serialVersionUID = 1257459213747478900L;
	
	/**
	 * 主订单id
	 */
	private Long orderId;
	
	/**
	 * 商品名称
	 */
	private String prodName;
	
	/**
	 * 商品图片
	 */
	private String prodImg;
	
	/**
	 * 商品sku属性信息
	 */
	private String attributes;
	
	/**
	 * 购买商品数量
	 */
	private Integer quantity;
	
	/**
	 * 订单总额
	 */
	private Double amount;
	
	/**
	 * 订单状态
	 */
	private OrderItem.Status status;

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public String getProdName() {
		return prodName;
	}

	public void setProdName(String prodName) {
		this.prodName = prodName;
	}

	public String getProdImg() {
		return prodImg;
	}

	public void setProdImg(String prodImg) {
		this.prodImg = prodImg;
	}

	public String getAttributes() {
		return attributes;
	}

	public void setAttributes(String attributes) {
		this.attributes = attributes;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public Double getAmount() {
		return amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public OrderItem.Status getStatus() {
		return status;
	}

	public void setStatus(OrderItem.Status status) {
		this.status = status;
	}
	
	
	public static class Builder{
		/**
		 * 主订单id
		 */
		private Long orderId;
		
		/**
		 * 商品名称
		 */
		private String prodName;
		
		/**
		 * 商品图片
		 */
		private String prodImg;
		
		/**
		 * 商品sku属性信息
		 */
		private String attributes;
		
		/**
		 * 购买商品数量
		 */
		private Integer quantity;
		
		/**
		 * 订单总额
		 */
		private Double amount;
		
		/**
		 * 订单状态
		 */
		private OrderItem.Status status;
		
		public Builder(Long orderId, Double amount){
			this.orderId = orderId;
			this.amount = amount;
		}

		public Builder prodName(String prodName) {
			this.prodName = prodName;
			return this;
		}

		public Builder prodImg(String prodImg) {
			this.prodImg = prodImg;
			return this;
		}

		public Builder attributes(String attributes) {
			this.attributes = attributes;
			return this;
		}

		public Builder quantity(Integer quantity) {
			this.quantity = quantity;
			return this;
		}

		public Builder status(OrderItem.Status status) {
			this.status = status;
			return this;
		}
		
		public OrderListDto build(){
			return new OrderListDto(this);
		}
		
		
	}
	
	private OrderListDto(Builder builder){
		orderId = builder.orderId;
		prodName = builder.prodName;
		prodImg = builder.prodImg;
		attributes = builder.attributes;
		quantity = builder.quantity;
		amount = builder.amount;
		status = builder.status;
	}

}

