package com.rocoinfo.rocomall.entity;

import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.OrderItem;

import java.util.Date;

/**
 * 退换货记录实体类
 * 
 * @author yunpeng
 */
public class ProdReturnRecord extends IdEntity {

	private static final long serialVersionUID = 9095330584435487881L;

	/**
	 * 订单详情
	 */
	private OrderItem orderItem;

	/**
	 * 操作人ID，不做关联，查询 操作的人ID
	 */
	private long operatorId;
	/**
	 * 操作人Name，不做关联，查询 当时操作人的姓名
	 */
	private String operatorName;

	/**
	 * 退换货描述
	 */
	private String note;

	/**
	 * 换货1,退货2
	 */
	private int type;

	/**
	 * 状态：1：换货中 ，2：换货成功，3：退货中，4：已退货
	 */
	private int status;
	/**
	 * 退换货数量
	 */
	private int count;

	/**
	 * 订单时间
	 */
	private Date orderCreateTime;
	/**
	 * 处理退换货的时间
	 */
	private Date orderOpTime;
	/**
	 * 退换货完成时间
	 */
	private Date orderFinishTime;

	private User user;

	private Sku sku;

	public OrderItem getOrderItem() {
		return orderItem;
	}

	public void setOrderItem(OrderItem orderItem) {
		this.orderItem = orderItem;
	}

	public long getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(long operatorId) {
		this.operatorId = operatorId;
	}

	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public Date getOrderCreateTime() {
		return orderCreateTime;
	}

	public void setOrderCreateTime(Date orderCreateTime) {
		this.orderCreateTime = orderCreateTime;
	}

	public Date getOrderOpTime() {
		return orderOpTime;
	}

	public void setOrderOpTime(Date orderOpTime) {
		this.orderOpTime = orderOpTime;
	}

	public Date getOrderFinishTime() {
		return orderFinishTime;
	}

	public void setOrderFinishTime(Date orderFinishTime) {
		this.orderFinishTime = orderFinishTime;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Sku getSku() {
		return sku;
	}

	public void setSku(Sku sku) {
		this.sku = sku;
	}
}