package com.rocoinfo.rocomall.entity.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import org.springframework.data.annotation.Transient;

/**
 * <dl>
 * <dd>描述: 账户</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月3日 上午10:41:08</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public class Account extends IdEntity {
    private static final long serialVersionUID = -9021209586825255518L;
    private String username;
    private String password;
    private String name;
    private String salt;

    private SwitchStatus status;

    /**
     * 明文密码
     */
    @Transient
    private String plainPassword;

    /**
     * 重复密码 校验用
     */
    @Transient
    private String confirmPassword;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getPlainPassword() {
        return plainPassword;
    }

    public void setPlainPassword(String plainPassword) {
        this.plainPassword = plainPassword;
    }

    public SwitchStatus getStatus() {
        return status;
    }

    public void setStatus(SwitchStatus status) {
        this.status = status;
    }

    public String getConfirmPassword() {
        return confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }
}