package com.rocoinfo.rocomall.entity.account;

import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.enumconst.CacheableTag;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.redis.CacheKeys;
import org.springframework.data.annotation.Transient;

import javax.xml.bind.annotation.*;
import java.util.List;

/**
 * <dl>
 * <dd>描述:后台管理用户</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年7月31日 下午2:56:22</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@XmlType
@XmlRootElement(name = "admin")
@XmlAccessorType(XmlAccessType.FIELD)
@CacheableTag(cacheKeyPrev = CacheKeys.ADMIN_USER_KEY_PREFIX)
public class AdminUser extends Account {

	private static final long serialVersionUID = 1111518481746742473L;

	public AdminUser() {

	}

	@XmlElement(name = "roleName")
	private String roleName;
	@XmlElement(name = "suppliers")
	private String supplierStr;

	public AdminUser(Long id) {
		this.id = id;
	}

	// 系统内置管理员
	public static final AdminUser ADMIN;

	static {
		ADMIN = new AdminUser();
		ADMIN.setUsername("admin");
		ADMIN.setStatus(SwitchStatus.OPEN);
	}

	@Transient
	private List<Role> roles; // 管理员拥有的角色
	@Transient
	private List<Supplier> suppliers; // 管理员能够管理的供应商

	public List<Role> getRoles() {
		return roles;
	}

	public void setRoles(List<Role> roles) {
		this.roles = roles;
	}

	public List<Supplier> getSuppliers() {
		return suppliers;
	}

	public void setSuppliers(List<Supplier> suppliers) {
		this.suppliers = suppliers;
	}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	public String getSupplierStr() {
		return supplierStr;
	}

	public void setSupplierStr(String supplierStr) {
		this.supplierStr = supplierStr;
	}
	
	
}
