package com.rocoinfo.rocomall.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.entity.Address;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.data.annotation.Transient;

import java.util.Date;
import java.util.List;

/**
 * 用户
 *
 * @author zhangmin
 * @author kanglong
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class User extends Account {
    private static final long serialVersionUID = -4563718697960955312L;

    /**
     * 绑定的手机号
     **/
    private String mobilePhone;

    /**
     * 出生日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date birthday;

    /**
     * 性别
     **/
    private String gender;

    /**
     * 注册时间
     */
    private Date registerDate;

    /**
     * 身份证号
     **/
    private String idCard;

    /**
     * 头像
     */
    private String imgUrl;

    // 会员的收获地址
    @Transient
    private List<Address> addressLists;

    public User() {
    }

    public User(Long id) {
        this.id = id;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }


    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public List<Address> getAddressLists() {
        return addressLists;
    }

    public void setAddressLists(List<Address> addressLists) {
        this.addressLists = addressLists;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public void setMobile(String mobile) {
        this.mobilePhone = mobile;
    }

    public String getMobile() {
        return this.mobilePhone;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }
}