package com.rocoinfo.rocomall.entity.activity;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.Order;
import org.springframework.data.annotation.Transient;

import java.util.Date;

/**
 * Created by wangx on 14-10-21.
 */
public class ActivityRecord extends IdEntity {

	private static final long serialVersionUID = -1327447737346156861L;

	// 支付成功后，并中奖后 立即 扣减库存
	private Activity activity;

	private User user;

	// 参加活动花费的积分
	private Integer cent;

	private Date joinTime;
	private Date eraseTime;
	private Status status;

	private ActivitySku activitySku;

	private Order order;

	@Transient
	private String skuName;

	public enum Status {
		HIT("中奖"), LOST("未中奖"), EXPIRED("已超时");
		private final String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	public Activity getActivity() {
		return activity;
	}

	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Date getJoinTime() {
		return joinTime;
	}

	public void setJoinTime(Date joinTime) {
		this.joinTime = joinTime;
	}

	public Date getEraseTime() {
		return eraseTime;
	}

	public void setEraseTime(Date eraseTime) {
		this.eraseTime = eraseTime;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public Order getOrder() {
		return order;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	public ActivitySku getActivitySku() {
		return activitySku;
	}

	public void setActivitySku(ActivitySku activitySku) {
		this.activitySku = activitySku;
	}

	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

}