package com.rocoinfo.rocomall.entity.cent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.dict.DictCentConsumeType;
import com.rocoinfo.rocomall.entity.dict.DictPlatform;
import org.springframework.data.annotation.Transient;

import java.util.Date;
import java.util.List;

/**
 * @author zhangmin
 */
public class CentConsumeRecord extends IdEntity {
	
	private static final long serialVersionUID = 9108758747802288708L;
	
	/**
	 * 流水号
	 */
	private String snNum;  
	
	private DictCentConsumeType consumeType;

    private DictPlatform platform;
	
	private Integer consumeCent;
	
	private User user;
	
	private Long entityId;
	
	private Status status;
	
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date dateline;
	
	@Transient
	private List<CentConsumeDetail> centDetails;
	
	public enum Status{
		CONSUME("消耗积分"),REFUND("退还积分");
		
		Status(String label){
			this.label = label;
		}
		
		private String label;

		public String getLabel() {
			return label;
		}
	}
	
	
	public String getSnNum() {
		return snNum;
	}

	public void setSnNum(String snNum) {
		this.snNum = snNum;
	}


	public Integer getConsumeCent() {
		return consumeCent;
	}

	public void setConsumeCent(Integer consumeCent) {
		this.consumeCent = consumeCent;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Long getEntityId() {
		return entityId;
	}

	public void setEntityId(Long entityId) {
		this.entityId = entityId;
	}

	public Date getDateline() {
		return dateline;
	}

	public void setDateline(Date dateline) {
		this.dateline = dateline;
	}
	
	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public List<CentConsumeDetail> getCentDetails() {
		return centDetails;
	}

	public void setCentDetails(List<CentConsumeDetail> centDetails) {
		this.centDetails = centDetails;
	}

    public DictPlatform getPlatform() {
        return platform;
    }

    public void setPlatform(DictPlatform platform) {
        this.platform = platform;
    }

    public DictCentConsumeType getConsumeType() {
        return consumeType;
    }

    public void setConsumeType(DictCentConsumeType consumeType) {
        this.consumeType = consumeType;
    }
}