package com.rocoinfo.rocomall.entity.cent;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.dict.DictPlatform;

import java.util.Date;

/**
 * @author weiys
 */
public class Cents extends IdEntity {

	private static final long serialVersionUID = -8985955378932624673L;

	private String code;

	private Integer cent;

	private Integer balance;

	private Date effectiveDate;

	private Date expireDate;

	private Status status;

	private String ruleCode;

	private DictPlatform platform;

	private User user;

	private String ouid;

	private java.util.Date dateline;

	private Date createTime;

	private CentRule centRule;
	
	private Long applyId;

	public static enum Status {
		// 积分已失效 就是 积分过期了
		CANUSE("可用"), USED("已使用完毕"), INVALID("已失效"), LOCK("锁定"), FROZEN("冻结");
		private final String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	public enum TTLUnit {
		DAY, MONTH
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code == null ? null : code.trim();
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public Integer getBalance() {
		return balance;
	}

	public void setBalance(Integer balance) {
		this.balance = balance;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public Date getExpireDate() {
		return expireDate;
	}

	public boolean isExpired() {
		return this.expireDate != null && new Date(System.currentTimeMillis()).after(expireDate);
	}

	public void setExpireDate(Date expireDate) {
		this.expireDate = expireDate;
	}

	public String getRuleCode() {
		return ruleCode;
	}

	public void setRuleCode(String ruleCode) {
		this.ruleCode = ruleCode == null ? null : ruleCode.trim();
	}

	public String getOuid() {
		return ouid;
	}

	public void setOuid(String ouid) {
		this.ouid = ouid;
	}

	public java.util.Date getDateline() {
		return dateline;
	}

	public void setDateline(java.util.Date dateline) {
		this.dateline = dateline;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public DictPlatform getPlatform() {
		return platform;
	}

	public void setPlatform(DictPlatform platform) {
		this.platform = platform;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public CentRule getCentRule() {
		return centRule;
	}

	public void setCentRule(CentRule centRule) {
		this.centRule = centRule;
	}

	public Long getApplyId() {
		return applyId;
	}

	public void setApplyId(Long applyId) {
		this.applyId = applyId;
	}
	
}