package com.rocoinfo.rocomall.entity.coupons;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.IdEntity;

import java.util.Date;

/**
 * 优惠卷模板 实体类
 * 
 * @author YUZHE 2015年12月11日 上午11:52:36
 */
public class CouponsInfo extends IdEntity {

	private static final long serialVersionUID = 1270359462545611234L;
	//编码
	private String code;
	//满多少金额
	private Double fullAmt;
	//减多少金额
	private Double minusAmt;
	//状态（启用，停用）
	private Status status;
	//生效时间
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date effectiveTime;
	//失效时间
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date unEffectiveTime;
	//创建时间
	@JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT+8")
	private Date createTime;

	public static enum Status {
		USING("启用"), DISABLE("停用");

		private String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Double getFullAmt() {
		return fullAmt;
	}

	public void setFullAmt(Double fullAmt) {
		this.fullAmt = fullAmt;
	}

	public Double getMinusAmt() {
		return minusAmt;
	}

	public void setMinusAmt(Double minusAmt) {
		this.minusAmt = minusAmt;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public Date getEffectiveTime() {
		return effectiveTime;
	}

	public void setEffectiveTime(Date effectiveTime) {
		this.effectiveTime = effectiveTime;
	}

	public Date getUnEffectiveTime() {
		return unEffectiveTime;
	}

	public void setUnEffectiveTime(Date unEffectiveTime) {
		this.unEffectiveTime = unEffectiveTime;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 返回有效状态 0：尚未生效, 1:有效, -1: 过期 失效
	 */
	public int getEffectiveStatus() {
		Date now = new java.sql.Date(System.currentTimeMillis());
		if (this.effectiveTime == null || now.before(this.effectiveTime)) {
			return 0;
		}

		if (unEffectiveTime != null && now.getTime() >= unEffectiveTime.getTime()) {
			return -1;
		}
		return 1;
	}
}
