package com.rocoinfo.rocomall.entity.dict.express;

import com.rocoinfo.rocomall.entity.IdEntity;
import org.springframework.data.annotation.Transient;

import java.util.List;

/**
 * 快递运费模版（主）
 * 
 * @author YUZHE
 */
public class ExpressFeeTemplate extends IdEntity {

	private static final long serialVersionUID = 1405503413585316734L;

	//模板名称
	private String name;

	//计价方式
	private CalcWay calcWay;

	//模板关联 物流公司
	private DictExpress express;

	private QuantityAmt def;

	public QuantityAmt getDef() {
		return def;
	}

	public void setDef(QuantityAmt def) {
		this.def = def;
	}

	//所有模板子项
	@Transient
	private List<ExpressFeeItem> items;

	//计价方式枚举
	public enum CalcWay {
		A("按件数"), KG("按重量"), M3("按体积");
		private final String label;

		CalcWay(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}

		public String getValue() {
			return this.name();
		}
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public CalcWay getCalcWay() {
		return calcWay;
	}

	public void setCalcWay(CalcWay calcWay) {
		this.calcWay = calcWay;
	}

	public DictExpress getExpress() {
		return express;
	}

	public void setExpress(DictExpress express) {
		this.express = express;
	}

	public List<ExpressFeeItem> getItems() {
		return items;
	}

	public void setItems(List<ExpressFeeItem> items) {
		this.items = items;
	}
}
