package com.rocoinfo.rocomall.entity.order;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;
import com.rocoinfo.rocomall.enumconst.Gender;
import com.rocoinfo.rocomall.utils.JsonUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:保险保单订单</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2016年1月5日12:55:46</dd>
 * <dd>创建人： Johnny</dd>
 * </dl>
 */
@SuppressWarnings("all")
public class OrderInsurance extends IdEntity {
	/**
	 * 方案名称，未知。
	 */
	private String schemeName;

	/**
	 * 缴费方式：趸交-0,5年-5,10年-10
	 */
	private Integer payway;
	/**
	 * (该日期为企业统一指定生效日期)保单生效日期
	 */
	private Date effectDate;
	/**
	 * 保额人保额
	 */
	private Double coverage;
	/**
	 * 个人支付保费
	 */
	private Double payment;
	/**
	 * 保单编号(需要保险公司导出后导入进来)
	 */
	private String insuredCode;
	/**
	 * 订单单号(系统记录的订单号，内部使用)
	 */
	private String orderCode;
	/**
	 * 投保人
	 */
	private InsuredInfo insuredInfo;
	/**
	 * 被投保人
	 */
	private InsuredInfo applicant;

	/**
	 * 所属公司
	 */
	private String companyName;

	/**
	 * 保单进度状态
	 */
	private StatusEnum status;

	/**
	 * 健康通知，json格式: 可以无限扩展通知类型
	 * 
	 * {体检项目:1,体检项目2:0} 1代表通过，0代表没通过
	 */
	private String healthyJson;

	/**
	 * 是否已经审阅(如果客户端不传入，则不让保存。)
	 */
	private Boolean isRead;

	/**
	 * 与被保险人关系
	 */
	private String relation;

	/**
	 * 卡号
	 */
	private String bankCard;

	/**
	 * 持卡人
	 */
	private String cardholder;

	/**
	 * 银行名称
	 */
	private String bankName;

	/**
	 * 保险单创建日期
	 */
	private Date createDate;

	/**
	 * 个人支付保费
	 */
	public Double getPayment() {
		Map<String, String> rule = null;
		if (this.getApplicant().getGender() == Gender.male) {
			rule = JsonUtils.fromJson(PropertyHolder.getInsuranceMale(), Map.class);
		} else if (this.getApplicant().getGender() == Gender.female) {
			rule = JsonUtils.fromJson(PropertyHolder.getInsuranceFemale(), Map.class);
		}
		if (rule == null) {
			payment = 0d;
		}
		//long age = ((new java.util.Date()).getYear() - this.getApplicant().getBirthdate().getYear());
		long age =  this.getApplicant().getAge() ;
		String payInfo = rule.get(age + "_" + this.getPayway());
		if (StringUtils.isEmpty(payInfo)) {
			payment = 0d;
		} else {
			payment = Double.parseDouble(payInfo) * 10 * this.getCoverage();
		}
		return payment;
	}

	public enum StatusEnum {
		SCUESS("已承保"), COMPLETE_PAY("已支付"), FINISH("待支付");

		private String label;

		StatusEnum(String lable) {
			this.label = lable;
		}

		public String getLabel() {
			return this.label;
		}
	}

	/**
	 * 方案名称，未知。
	 */
	public String getSchemeName() {
		return schemeName;
	}

	/**
	 * 方案名称，未知。
	 */
	public void setSchemeName(String schemeName) {
		this.schemeName = schemeName;
	}

	/**
	 * 缴费方式：趸交-0,5年-5,10年-10
	 */
	public Integer getPayway() {
		return payway;
	}

	/**
	 * 缴费方式：趸交-0,5年-5,10年-10
	 */
	public void setPayway(Integer payway) {
		this.payway = payway;
	}

	/**
	 * (该日期为企业统一指定生效日期)保单生效日期
	 */
	public Date getEffectDate() {
		return effectDate;
	}

	/**
	 * (该日期为企业统一指定生效日期)保单生效日期
	 */
	public void setEffectDate(Date effectDate) {
		this.effectDate = effectDate;
	}

	/**
	 * 保额人保额
	 */
	public Double getCoverage() {
		return coverage;
	}

	/**
	 * 保额人保额
	 */
	public void setCoverage(Double coverage) {
		this.coverage = coverage;
	}

	/**
	 * 保单编号(需要银行提交)
	 */
	public String getInsuredCode() {
		return insuredCode;
	}

	/**
	 * 保单编号(需要银行提交)
	 */
	public void setInsuredCode(String insuredCode) {
		this.insuredCode = insuredCode;
	}

	/**
	 * 投保人
	 */
	public InsuredInfo getInsuredInfo() {
		return insuredInfo;
	}

	/**
	 * 投保人
	 */
	public void setInsuredInfo(InsuredInfo insuredInfo) {
		this.insuredInfo = insuredInfo;
	}

	/**
	 * 被投保人
	 */
	public InsuredInfo getApplicant() {
		return applicant;
	}

	/**
	 * 被投保人
	 */
	public void setApplicant(InsuredInfo applicant) {
		this.applicant = applicant;
	}

	/**
	 * 保单进度状态
	 */
	public StatusEnum getStatus() {
		return status;
	}

	/**
	 * 保单进度状态
	 */
	public void setStatus(StatusEnum status) {
		this.status = status;
	}

	/**
	 * 健康通知，json格式: 可以无限扩展通知类型
	 * 
	 * {体检项目:1,体检项目2:0} 1代表通过，0代表没通过
	 */
	public String getHealthyJson() {
		return healthyJson;
	}

	/**
	 * 健康通知，json格式: 可以无限扩展通知类型
	 * 
	 * {体检项目:1,体检项目2:0} 1代表通过，0代表没通过
	 */
	public void setHealthyJson(String healthyJson) {
		this.healthyJson = healthyJson;
	}

	/**
	 * 是否已经审阅(如果客户端不传入，则不让保存。)
	 */
	public Boolean getIsRead() {
		return isRead;
	}

	/**
	 * 是否已经审阅(如果客户端不传入，则不让保存。)
	 */
	public void setIsRead(Boolean isRead) {
		this.isRead = isRead;
	}

	/**
	 * 个人支付保费
	 */
	public void setPayment(Double payment) {
		this.payment = payment;
	}

	/**
	 * 订单单号(系统记录的订单号，内部使用)
	 */
	public String getOrderCode() {
		return orderCode;
	}

	/**
	 * 订单单号(系统记录的订单号，内部使用)
	 */
	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	/**
	 * 所属公司
	 */
	public String getCompanyName() {
		return companyName;
	}

	/**
	 * 所属公司
	 */
	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	/**
	 * 与被保险人关系
	 */
	public String getRelation() {
		return relation;
	}

	/**
	 * 与被保险人关系
	 */
	public void setRelation(String relation) {
		this.relation = relation;
	}

	/**
	 * 卡号
	 */
	public String getBankCard() {
		return bankCard;
	}

	/**
	 * 卡号
	 */
	public void setBankCard(String bankCard) {
		this.bankCard = bankCard;
	}

	/**
	 * 持卡人
	 */
	public String getCardholder() {
		return cardholder;
	}

	/**
	 * 持卡人
	 */
	public void setCardholder(String cardholder) {
		this.cardholder = cardholder;
	}

	/**
	 * 银行名称
	 */
	public String getBankName() {
		return bankName;
	}

	/**
	 * 银行名称
	 */
	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	/**
	 * 保险单创建日期
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * 保险单创建日期
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
}