package com.rocoinfo.rocomall.jms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

import javax.jms.*;

/**
 * JMS库存消息生产者.
 *
 * @author liuwei
 */
public class StockMessageProducer {

    private Logger logger = LoggerFactory.getLogger(StockMessageProducer.class);

    private JmsTemplate jmsTemplate;
    private Destination notifyQueue;

    public void sendQueue(final String proId, final int stock) {
        logger.debug("正在JMS消息。proId: {}, stock: {}", proId, stock);
        jmsTemplate.send(notifyQueue, new MessageCreator() {
            @Override
            public Message createMessage(Session session) throws JMSException {
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setString("proId", proId);
                mapMessage.setInt("stock", stock);
                return mapMessage;
            }
        });
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setNotifyQueue(Destination notifyQueue) {
        this.notifyQueue = notifyQueue;
    }
}
