package com.rocoinfo.rocomall.pay;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.BankPaylog;
import com.rocoinfo.rocomall.enumconst.BankType;

import javax.servlet.http.HttpServletRequest;

/**
 * 
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-11-6 下午2:14:23</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public interface IBankPayLogService extends IBaseService<BankPaylog> {

	/**
	 * 通过订单的id。生成一条支付记录
	 * 
	 * @param id
	 *            商城的订单id
	 * @param bankType
	 */
	// BankPaylog createOrFindBankPayLogByOrderId(Long orderId, BankType
	// bankType, double amount, Date Date orderCreateTm);

	/**
	 * 判断该订单是否已经支付过
	 * 
	 * @param id
	 *            订单id。商城积分id
	 */
	boolean isPaySuccess(Long id);

	void updateStatusToSuccess(String bankOrderId, BankType banktype);

	void updateStatusToFail(String bankOrderId, BankType banktype);

	void operatePayResult(BankType banktype, boolean status, String outTradeNo);

	public CommonPayDto buildPayInfo(Long orderId, String returnUrl, String notifyUrl, BankType bankType);

	/**
	 * 支付业务逻辑处理
	 */
	public boolean payCall(HttpServletRequest request, BankType bankType);
}
