package com.rocoinfo.rocomall.pay.alipay;

import com.rocoinfo.rocomall.pay.MD5;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 支付宝支付
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-10-28 下午1:33:31</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public class AlipayInterfaceHelper {
	private static Logger logger = LoggerFactory.getLogger(AlipayInterfaceHelper.class);
	// 合作身份者ID，以2088开头由16位纯数字组成的字符串
	public static String partner;
	// 客户私钥
	public static String key;
	// 卖家支付宝账号，格式为邮箱或手机号。
	public static String seller_email;
	// 字符编码格式 目前支持 gbk 或 utf-8
	public static final String input_charset = "utf-8";
	// 签名方式 不需修改
	public static final String sign_type = "MD5";
	// 支付类型
	public static final String type = "1";
	// 支付宝地址
	public static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do";

	public static Map<String, String> buildQueryParam(AlipayQueryBaseMeta baseMeta) {
		// 把请求参数打包成数组
		Map<String, String> sParaTemp = new HashMap<String, String>();
		sParaTemp.put("service", "create_direct_pay_by_user");
		// 签约的支付宝账号对应的支付宝唯一用户号。 以2088开头的16位纯数字组成。
		sParaTemp.put("partner", partner);
		sParaTemp.put("_input_charset", input_charset);
		if (StringUtils.isNotBlank(baseMeta.getNotifyUrl())) {
			sParaTemp.put("notify_url", baseMeta.getNotifyUrl());// 异步接口
		}
		if (StringUtils.isNotBlank(baseMeta.getReturnUrl())) {
			sParaTemp.put("return_url", baseMeta.getReturnUrl());
		}
		sParaTemp.put("out_trade_no", baseMeta.getOutTradeNo());// 商户网站唯一订单号
		sParaTemp.put("subject", baseMeta.getSubject());// 商品名称
		sParaTemp.put("payment_type", type);// 支付类型
		sParaTemp.put("total_fee", String.valueOf(baseMeta.getTotalFee()));// 交易金额

		if (StringUtils.isNotBlank(seller_email)) {
			sParaTemp.put("seller_email", seller_email);// 卖家支付宝账号，格式为邮箱或手机号。
		}
		if (StringUtils.isNotBlank(baseMeta.getBody())) {
			sParaTemp.put("body", baseMeta.getBody());// 商品描述
		}
		if (StringUtils.isNotBlank(baseMeta.getShowUrl())) {
			sParaTemp.put("show_url", baseMeta.getShowUrl());// 商品展示网址,收银台页面上，商品展示的超链接
		}
		return buildRequestPara(sParaTemp);
	}

	public static boolean validateReturnMsg(HttpServletRequest request) {
		Map<String, String> params = new HashMap<String, String>();
		Map requestParams = request.getParameterMap();
		for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
			String name = (String) iter.next();
			String[] values = (String[]) requestParams.get(name);
			String valueStr = "";
			for (int i = 0; i < values.length; i++) {
				valueStr = (i == values.length - 1) ? valueStr + values[i] : valueStr + values[i] + ",";
			}
			// 乱码解决，这段代码在出现乱码时使用。如果mysign和sign不相等也可以使用这段代码转化
			// valueStr = new String(valueStr.getBytes("ISO-8859-1"),
			// "utf-8");
			logger.info("{}------{}", name, valueStr);
			params.put(name, valueStr);
		}
		boolean isSignOk = AlipayNotify.verify(params);
		logger.info("数据合法性{}", isSignOk);
		return isSignOk;
	}

	/**
	 * 验证交易是否成功
	 * 
	 * @param tradeStatus
	 * @return
	 */
	public static boolean isPaySuccess(HttpServletRequest request) {
		String tradeStatus = request.getParameter("trade_status");
		if (validateReturnMsg(request)) {
			boolean isPaySuccess = StringUtils.isNotBlank(tradeStatus)
					&& (StringUtils.equals(tradeStatus, "TRADE_SUCCESS") || StringUtils.equals(tradeStatus, "TRADE_FINISHED"));
			logger.info("交易状态{}", isPaySuccess);
			return isPaySuccess;
		}
		return false;
	}

	/**
	 * 生成要请求给支付宝的参数数组
	 * 
	 * @param sParaTemp
	 *            请求前的参数数组
	 * @return 要请求的参数数组
	 */
	private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
		// 除去数组中的空值和签名参数
		Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
		// 生成签名结果
		String mysign = buildRequestMysign(sPara);

		// 签名结果与签名方式加入请求提交参数组中
		sPara.put("sign_type", sign_type);
		sPara.put("sign", mysign);

		return sPara;
	}

	/**
	 * 生成签名结果
	 * 
	 * @param sPara
	 *            要签名的数组
	 * @return 签名结果字符串
	 */
	private static String buildRequestMysign(Map<String, String> sPara) {
		String prestr = AlipayCore.createLinkString(sPara); // 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		String mysign = "";
		if (sign_type.equals("MD5")) {
			mysign = MD5.sign(prestr, key, input_charset);
		}
		return mysign;
	}

	public static class AlipayQueryBaseMeta {
		private String notifyUrl;// 异步接口
		private String returnUrl;// 支付成功后跳转页面
		private String outTradeNo;// 商户网站唯一订单号
		private String subject;// 商品名称 必填
		private double totalFee;// 交易金额
		private String body;
		private String showUrl;

		public AlipayQueryBaseMeta(String outTradeNo, String subject, double totalFee) {
			this.outTradeNo = outTradeNo;
			this.subject = subject;
			this.totalFee = totalFee;
		}

		public AlipayQueryBaseMeta(String outTradeNo, String subject, double totalFee, String returnUrl, String notifyUrl) {
			this(outTradeNo, subject, totalFee);
			this.returnUrl = returnUrl;
			this.notifyUrl = notifyUrl;
		}

		public String getNotifyUrl() {
			return notifyUrl;
		}

		public void setNotifyUrl(String notifyUrl) {
			this.notifyUrl = notifyUrl;
		}

		public String getReturnUrl() {
			return returnUrl;
		}

		public void setReturnUrl(String returnUrl) {
			this.returnUrl = returnUrl;
		}

		public String getOutTradeNo() {
			return outTradeNo;
		}

		public void setOutTradeNo(String outTradeNo) {
			this.outTradeNo = outTradeNo;
		}

		public String getSubject() {
			return subject;
		}

		public void setSubject(String subject) {
			this.subject = subject;
		}

		public double getTotalFee() {
			return totalFee;
		}

		public void setTotalFee(double totalFee) {
			this.totalFee = totalFee;
		}

		public String getBody() {
			return body;
		}

		public void setBody(String body) {
			this.body = body;
		}

		public String getShowUrl() {
			return showUrl;
		}

		public void setShowUrl(String showUrl) {
			this.showUrl = showUrl;
		}
	}
}
