package com.rocoinfo.rocomall.pay.chinabank;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.pay.MD5;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public class ChinaBankPayHelper {
	private static Logger logger = LoggerFactory.getLogger(ChinaBankPayHelper.class);
	public static String v_mid;// 1001是网银在线的测试商户号，商户要替换为自己的商户号。
	public static String key;
	public static final String v_moneytype = "CNY"; // 币种
	public static final String CHINABANK_GATEWAY_NEW = "https://pay3.chinabank.com.cn/PayGate";

	public static Map<String, String> buildQueryParam(ChBankQueryBaseMeta baseMeta) {
		Map<String, String> params = Maps.newHashMap();
		params.put("v_mid", v_mid);
		params.put("v_oid", baseMeta.getOrderid());
		params.put("v_amount", String.valueOf(baseMeta.getVamount()));
		params.put("v_moneytype", v_moneytype);
		params.put("v_url", baseMeta.getVurl());
		String text = baseMeta.getVamount() + v_moneytype + baseMeta.getOrderid() + v_mid + baseMeta.getVurl() + key; // 拼凑加密串
		String v_md5info = MD5.getMD5ofStr(text);// 对拼凑串MD5私钥加密后的值
		params.put("v_md5info", v_md5info);
		if (StringUtils.isNotBlank(baseMeta.getRemark2())) {
			params.put("remark2", baseMeta.getRemark2());
		}
		return params;
	}

	/**
	 * 验证返回的信息没有被纂改
	 * 
	 */
	public static boolean validateData(HttpServletRequest request) {
		String v_oid = request.getParameter("v_oid"); // 订单号
		String v_pstatus = request.getParameter("v_pstatus"); // 支付结果，20支付完成；30支付失败；
		String v_amount = request.getParameter("v_amount"); // 订单实际支付金额
		String v_moneytype = request.getParameter("v_moneytype"); // 币种
		String v_md5str = request.getParameter("v_md5str"); // MD5校验码
		String v_md5info = MD5.getMD5ofStr(v_oid + v_pstatus + v_amount + v_moneytype + key).toUpperCase();
		boolean result = StringUtils.equals(v_md5info, v_md5str);
		logger.info("数据验证结果:{}", result);
		return result;
	}

	/**
	 * 支付是否成功
	 * 
	 * @param
	 * @return
	 */
	public static boolean isPaySuccess(HttpServletRequest request) {
		String pstatus = request.getParameter("v_pstatus");
		return validateData(request) && StringUtils.equals("20", pstatus);
	}

	public static class ChBankQueryBaseMeta {
		private String orderid;// 订单id
		private double vamount;// 订单金额
		private String vurl;// 返回url
		private String remark2; // 服务器异步通知的接收地址。对应AutoReceive.jsp示例。必须要有[url:=]格式

		public ChBankQueryBaseMeta(String orderid, double vamount, String vurl, String remark2) {
			this.orderid = orderid;
			this.vamount = vamount;
			this.vurl = vurl;
			this.remark2 = "[url:=" + remark2 + "]";
		}

		public String getOrderid() {
			return orderid;
		}

		public double getVamount() {
			return vamount;
		}

		public String getVurl() {
			return vurl;
		}

		public String getRemark2() {
			return remark2;
		}

		public void setRemark2(String remark2) {
			this.remark2 = "[url:=" + remark2 + "]";
		}

		public void setOrderid(String orderid) {
			this.orderid = orderid;
		}

		public void setVamount(double vamount) {
			this.vamount = vamount;
		}

		public void setVurl(String vurl) {
			this.vurl = vurl;
		}
	}
}
