package com.rocoinfo.rocomall.pay.wechat;

import com.rocoinfo.rocomall.pay.chinapay.ChinaPayInterfaceHelper;
import com.rocoinfo.rocomall.utils.RestTemplateUtil;
import com.rocoinfo.rocomall.utils.XmlUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

/**
 * 微信支付
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-11-2 下午4:27:26</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public class WxpayHelper {

	private static Logger logger = LoggerFactory.getLogger(ChinaPayInterfaceHelper.class);

	public static String APPID;

	public static String MCHID;

	public static String SIGNATURE;

	public static String url = "https://api.mch.weixin.qq.com/pay/unifiedorder";

	public static String SUCCESS = "SUCCESS";

	/**
	 * 微信统一下单接口调用
	 * 
	 * @param parm
	 * @throws Exception
	 */
	public static UnifiedOrderResult wxUnifiedorder(UnifiedOrderParm parm) {
		parm.setAppId(WxpayHelper.APPID);
		parm.setMchId(WxpayHelper.MCHID);
		parm.setSign(WxSignUtil.sign(parm.getClass(), parm,WxpayHelper.SIGNATURE));
		RestTemplate restTemplates = RestTemplateUtil.getRestTemplateUtf8();
		String reqXml = XmlUtil.convertToXml(parm, "utf-8");
		logger.info("微信统一下单请求xml{}", reqXml);
		String returnXml = restTemplates.postForObject(url, reqXml, String.class);
		logger.info("微信统一下单返回xml{}", returnXml);
		if (StringUtils.isNotBlank(returnXml)) {
			return XmlUtil.converyToJavaBean(returnXml, UnifiedOrderResult.class);
		}
		return null;
	}

	/**
	 * 统一下单验证签名是否成功
	 * 
	 * @param result
	 * @return
	 */
	public static boolean validateUnifiedOrderSign(UnifiedOrderResult result) {
		if (result.isCanPay()) {
			return StringUtils.equals(WxSignUtil.sign(result.getClass(), result,WxpayHelper.SIGNATURE), result.getSign());
		}
		return false;
	}

	/**
	 * 微信支付通知接口，验证签名是否成功
	 * 
	 * @param result
	 * @return
	 */
	public static boolean isPaySuccess(NotifyResultParm result) {
		boolean status = result.isPaySuccess();
		if (status) {
			return StringUtils.equals(WxSignUtil.sign(result.getClass(), result,WxpayHelper.SIGNATURE), result.getSign());
		}
		return false;
	}
}