package com.rocoinfo.rocomall.repository;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.BankPaylog;
import com.rocoinfo.rocomall.enumconst.BankType;
import org.apache.ibatis.annotations.Param;

/**
 * 
 * <dl>
 * <dd>描述:银行支付日志</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-11-6 下午2:21:08</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@SuppressWarnings("all")
@MyBatisRepository
public interface BankPayLogDao extends CrudDao<BankPaylog> {

	BankPaylog findBySelfOrderIdAndBankType(@Param("selfOrderid") String id, @Param("bankType") BankType bankType);

	BankPaylog findByBankOrderIdAndBankType(@Param("bankOrderId") String id, @Param("bankType") BankType bankType);

	int countPaySuccess(long selfOrderid);

	void updateStatusToSuccess(@Param("bankOrderId") String bankOrderId, @Param("bankType") BankType banktype);

	void updateStatusToFail(@Param("bankOrderId") String bankOrderId, @Param("bankType") BankType banktype);
}
