package com.rocoinfo.rocomall.repository;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.CartItem;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: </dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/23 10:10</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 */
@MyBatisRepository
public interface CartDao extends CrudDao<CartItem> {

    void saveCardItems(final CartItem... items);

    List<CartItem> getCartItemListByUserId(final long userId);

    void removeCartItem(Map<String, Object> paramMap);

    /**
     * 修改cartItem的购买数量
     */
    void modifyCardItemQuantity(final CartItem cartItem);

    void batchModifyCartItemQts(@Param("itemIds") List<Long> itemIdList, @Param("quantities") List<Integer> quantityList);


    /**
     * 更新用户选中购买的sku
     *
     * @param userId        用户Id
     * @param checkedSkuIds 在购物车中被选中的skuId
     */
    void updateCartItemCheckedIn(@Param("userId") final long userId, @Param("skuIds") String checkedSkuIds);
}
