package com.rocoinfo.rocomall.repository;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.ProdStockApplyItem;

import java.util.List;

/**
 * <dl>
 * <dd>描述:  ProdStockApplyItemDao 接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/2 10:49</dd>
 * <dd>创建人：fan</dd>
 * </dl>
 */
@MyBatisRepository
public interface ProdStockApplyItemDao extends CrudDao<ProdStockApplyItem> {

    /**
     * 根据申请单id 删除申请单中的item
     *
     * @param applyId
     */
    int deleteByApplyId(Long applyId);

    /**
     * 根据申请单id 查询申请单中的item
     *
     * @param applyId
     * @return
     */
    List<ProdStockApplyItem> getByApplyId(Long applyId);
}
