package com.rocoinfo.rocomall.repository;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.Sku;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@MyBatisRepository
public interface SkuDao extends CrudDao<Sku> {

	List<Sku> findAllListedSkuWithProd();

	List<Sku> getByProductId(Long productId);

	List<Sku> findSkuWithProdByIdIn(List<Long> skuIds);

	List<Sku> findByIdIn(List<Long> skuIds);

	int countByCode(String code);

	Long getSkuIdByAttributes(Map<String, Object> parameters);

	List<Map<String, Object>> findSkuCentAndDicountByIdIn(List<Long> skuIds);

	void incrOrDecrOccupiedStock(@Param("skuIdList") List<Long> skuIdList, @Param("qtyList") final List<Integer> qtyList);

	/**
	 * 增加|减少 良品库存
	 * 
	 * @param dictWareHouseId 仓库Id,如果是出库时，则传null,入库传仓库id
	 */
	void incrOrDecrStock(@Param("skuId") Long skuId, @Param("quantity") Integer quantity, @Param("wareHouseId") Long dictWareHouseId);

	@Deprecated
	void batchIncreaseOccupiedStockAndSaleVolumeOnPayed(@Param("skuIdList") final List<Long> skuIdList, @Param("quantityList") final List<Integer> quantityList);

	@Deprecated
	void decreaseStockAndOccupiedOnSend(@Param("skuId") long skuId, @Param("quantity") int quantity);

	@Deprecated
	void decreaseOccupiedStockAndSaleVolumeOnCancel(@Param("skuId") long skuId, @Param("quantity") int quantity);

	@Deprecated
	void decrStockAndIncrDefectStockOnExchange(@Param("skuId") long skuId, @Param("quantity") int quantity);

	@Deprecated
	void increaseStockOnRefundIfCanUse(@Param("skuId") long skuId, @Param("quantity") int quantity);

	@Deprecated
	void batchDecreaseStockAndOccupiedOnImport(@Param("skuIdList") final List<Long> skuIdList, @Param("quantityList") final List<Integer> quantityList);

	/**
	 * 当活动下架时，将SKU中活动信息字段设为null
	 */
	void setListedActivityColumnsNull(Long id);

	List<Sku> adminSearchJoin(Map<String, Object> parameters);

	Long adminSearchTotalJoin(Map<String, Object> parameters);

	Sku getByCode(String code);

	/**
	 * 根据skuid查询Sku的详细信息
	 * 
	 * @param skuId
	 * @return
	 */
	Sku findSkuWithProdBySkuId(Long skuId);
}
