package com.rocoinfo.rocomall.repository.activity;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.activity.Activity;
import com.rocoinfo.rocomall.entity.activity.ActivitySku;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动所关联的商品
 */
@MyBatisRepository
public interface ActivitySkuDao extends CrudDao<ActivitySku> {

	List<ActivitySku> getByActivityId(Long activityId);

	List<ActivitySku> findWithSkuDetailByActivityIdIn(List<Long> actIdList);

	void update(ActivitySku activitySku);

	void deleteByActivityId(Long activityId);

	List<Long> findActivityIdBySkuIdAndActivityStatus(@Param("skuId") Long skuId, @Param("status") Activity.Status status);

	List<Long> findListedActivityIdBySkuId(Long skuId);

	List<Long> findListedActivityIdBySkuIdIn(@Param("skuIds") List<Long> skuIds);

	List<Long> findProductIdByActivityId(Long activityId);

	List<ActivitySku> getSkusByActivityId(Long activityId);

	Long getTotalCentByActivityId(Long activityId);

	ActivitySku getById(Long id);

	void increaseHitNumById(Long id);

	List<Activity> getExclusiveActivityCountByskuId(@Param("skuId") Long skuId);
}
